/*
 * Created on Jul 8, 2003
 */
package Validators;

import Data.*;
import java.sql.*;

/**
 * This class is being used for validating Announcement data
 * 
 */
public class AnnouncementValidator {

	private String message;

	/**
	 * This method is being used to get the validation message
	 * @return String message
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used setting validation message
	 * @param String message 
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used to validate announcement data
	 * @param announcementData data to be validated
	 * @return boolean true if validation successful
	 */
	public boolean validate(AnnouncementData announcementData) {

		AnnouncementData announcementdata = announcementData;
		String from, body, subject;
		Timestamp time;

		from = announcementData.getFrom();
		body = announcementData.getBody();
		subject = announcementData.getSubject();
		time = announcementData.getTime();

		if (from.equals("") || body.equals("") || subject.equals("")) {
			message = "Please enter text. ";
			return false;
		}
		if (!subject.matches("^[a-zA-Z/`/'/s/ ]{1,50}+$")) {
					message = "Subject of the announcement has invalid characters.";
					message += " Subject of the announcement has to be less than 50 characters. ";
					return false;
		}
		if (!body.matches("^[a-zA-Z/`/'/s/ ]{1,128}+$")) {
			message = "Body of the announcement has invalid characters.";
			message += " Body of the announcement has to be less than 128 characters. ";
			return false;
		}		
		return true;

	}

}
